namespace win
	#include "windows.bi"
end namespace
using win
#define ID_FILE_EXIT 9001
#define ID_STUFF_GO 9002

declare function WinMain ( _
	byval hInstance as win.hInstance, _
	byval hPrevInstance as win.hInstance, _
	byval lpCmdLine as win.LPSTR, _
	byval nCmdShow as integer ) as integer
end WinMain( win.GetModuleHandle( NULL ), NULL, command, SW_NORMAL )

const as string g_szClassName = "myWindowClass"

function WndProc( _
	byval hwnd as win.HWND, _
	byval msg as win.UINT, _
	byval wParam as win.WPARAM, _
	byval lParam as win.LPARAM) as win.LRESULT
	
	select case msg
		case WM_CREATE
		scope
			dim as win.HMENU hMenu, hSubMenu
			dim as win.HICON hIcon, hIconSm
			
			hMenu = win.CreateMenu()
			
			hSubMenu = win.CreatePopupMenu()
			win.AppendMenu(hSubMenu, MF_STRING, ID_FILE_EXIT, "E&xit")
			win.AppendMenu(hMenu, MF_STRING or MF_POPUP, cast( uInteger, hSubMenu ), "&File")
			
			hSubMenu = win.CreatePopupMenu()
			win.AppendMenu(hSubMenu, MF_STRING, ID_STUFF_GO, "&Go")
			win.AppendMenu(hMenu, MF_STRING or MF_POPUP, cast( uInteger, hSubMenu ), "&Stuff")
			
			win.SetMenu(hwnd, hMenu)
			
			hIcon = win.LoadImage(NULL, "menu_two.ico", IMAGE_ICON, 32, 32, LR_LOADFROMFILE)
			if( ( hIcon ) <> 0 ) then
				win.SendMessage(hwnd, WM_SETICON, ICON_BIG, cast( win.lParam, hIcon ) )
			else
				win.MessageBox(hwnd, "Could not load large icon!", "Error", MB_OK or MB_ICONERROR)
			end if
			
			hIconSm = win.LoadImage(NULL, "menu_two.ico", IMAGE_ICON, 16, 16, LR_LOADFROMFILE)
			if( (hIconSm) <> 0 ) then
				win.SendMessage(hwnd, WM_SETICON, ICON_SMALL, cast(win.lParam, hIconSm) )
			else
				win.MessageBox(hwnd, "Could not load small icon!", "Error", MB_OK or MB_ICONERROR)
			end if
		end scope
		
		case WM_COMMAND
			select case LOWORD(wParam)
				case ID_FILE_EXIT
					win.PostMessage(hwnd, WM_CLOSE, 0, 0)
				case ID_STUFF_GO
					win.MessageBox(hwnd, "You clicked go!", "Woo!", MB_OK)
			end select
			
		case WM_CLOSE
			win.DestroyWindow(hwnd)
		
		case WM_DESTROY
			win.PostQuitMessage(0)
		
		case else
			return win.DefWindowProc(hwnd, msg, wParam, lParam)
	end select
	return 0
end function


function WinMain ( _
	byval hInstance as win.hInstance, _
	byval hPrevInstance as win.hInstance, _
	byval lpCmdLine as win.LPSTR, _
	byval nCmdShow as integer ) as integer
	
	dim as win.WNDCLASSEX wc
	dim as win.HWND hwnd
	dim as win.MSG msg

  	with wc
	.cbSize        = sizeof(win.WNDCLASSEX)
	.style         = 0
	.lpfnWndProc   = @WndProc()
	.cbClsExtra    = 0
	.cbWndExtra    = 0
	.hInstance     = hInstance
	.hIcon         = NULL
	.hCursor       = LoadCursor(NULL, IDC_ARROW)
	.hbrBackground = cast(HBRUSH, (COLOR_WINDOW+1))
	.lpszMenuName  = NULL
	.lpszClassName = strptr(g_szClassName)
	.hIconSm       = NULL
	end with
	
	if( win.RegisterClassEx( @wc ) = 0 ) then
		win.MessageBox( NULL, "Window Registration Failed!", "Error!", _
			MB_ICONEXCLAMATION or MB_OK )
		return 0
	end if
	
	hwnd = win.CreateWindowEx( _
		WS_EX_CLIENTEDGE, _
		g_szClassName, _
		"A Menu #2", _
		WS_OVERLAPPEDWINDOW, _
		CW_USEDEFAULT, CW_USEDEFAULT, 240, 120, _
		NULL, NULL, hInstance, NULL ) 

	if ( hwnd = NULL ) then
		win.MessageBox(NULL, "Window Creation Failed!", "Error!", MB_ICONEXCLAMATION or MB_OK )
		return 0
	end if
	
	win.ShowWindow( hwnd, nCmdShow )
	win.UpdateWindow( hwnd )

	while ( win.GetMessage( @Msg, NULL, 0, 0) > 0 )
		win.TranslateMessage(@Msg)
		win.DispatchMessage(@Msg)
	wend
	return Msg.wParam
	
end function